


export class AddressPopup {
	
	tpl = `
	<div class="customer-address-popup">
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				<a href="javascript:void(0);" [onclick]="widget.saveAddress" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuw adres':'Bewerk adres'}}</h1>
		</div>

		<form id="frmAddress">
			<ez-text name="street" label="Straat" [value]="address.street"></ez-text>
			
			<ez-text name="streetNo" label="Huisnr" [value]="address.streetNo"></ez-text>
			
			<ez-text name="zipcode" label="Postcode" [value]="address.zipcode"></ez-text>
			
			<ez-text name="city" label="Plaats" [value]="address.city"></ez-text>
			
			<ez-text name="country" label="Land" [value]="address.country"></ez-text>
			
			<ez-textarea name="note" label="Opmerking" [value]="address.note"></ez-text>
			
		</form>
	</div>
	`;
	
	isNew = true;
	
	
	address = {
		address_id: null,
		street:     '',
		streetNo:  '',
		zipcode:    '',
		city:       '',
		country:    '',
		note:       ''
	};
	
	container = null;
	
	callback_save = null;
	
	
	setAddress(a) {
		this.address = a;
		this.isNew = false;
	}
	
	setCallbackSave( c ) { this.callback_save = c; }
	
	
	saveAddress() {
		
		if (this.validate() > 0)
			return;
		
		if (this.callback_save) {
			this.callback_save( this.address, this );
		}
		
		close_popup();
	}
	
	validate() {
		this.address.street    = $('#frmAddress input[name=street]').val();
		this.address.streetNo  = $('#frmAddress input[name=streetNo]').val();
		this.address.zipcode   = $('#frmAddress input[name=zipcode]').val();
		this.address.city      = $('#frmAddress input[name=city]').val();
		this.address.country   = $('#frmAddress input[name=country]').val();
		this.address.note      = $('#frmAddress textarea[name=note]').val();
		
		this.address.street    = $.trim( this.address.street );
		this.address.streetNo  = $.trim( this.address.streetNo );
		this.address.zipcode   = $.trim( this.address.zipcode );
		this.address.city      = $.trim( this.address.city );
		this.address.country   = $.trim( this.address.country );

		let errorCount = 0;
		$(this.container).find('span.error').text( '' );
		
		if (this.address.street == '') {
			$('#frmAddress [name=street] .error').text('verplicht');
			errorCount++;
		}
		if (this.address.streetNo == '') {
			$('#frmAddress [name=streetNo] .error').text('verplicht');
			errorCount++;
		}
		if (this.address.city == '') {
			$('#frmAddress [name=city] .error').text('verplicht');
			errorCount++;
		}
		
		return errorCount;
	}
	
	
	close() {
		close_popup();
	}
	
	showPopup() {
		this.container = show_popup('Adres', '');
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setVar('address', this.address);
		ezTpl.setVar('isNew', this.isNew);
		ezTpl.setObject('widget', this);
		ezTpl.render();
		

		$('#frmAddress').find('input[name=street], input[name=city], input[name=country]').on('change', function(v) {
			this.value = ucfirst( trim( this.value ) );
		});

		$('#frmAddress input[name=zipcode]').on('change', function(v) {
			this.value = $.trim( this.value.toUpperCase() );
		});
		
		focusFirstField('#frmAddress');
	}
	
	
}

